/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.util;

import io.github.mortuusars.exposure.util.Vec3Util;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import net.minecraft.class_1297;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public record PointOfView(class_243 pos, class_243 dir) {
    public static PointOfView of(CameraHolder holder) {
        return PointOfView.of(holder.asHolderEntity());
    }

    public static PointOfView of(class_1297 entity) {
        return new PointOfView(entity.method_19538().method_1031(0.0, (double)entity.method_5751(), 0.0), class_243.method_1030((float)class_3532.method_15363((float)entity.method_36455(), (float)-89.0f, (float)89.0f), (float)entity.method_36454()));
    }

    public PointOfView rotateX(double degrees) {
        class_243 upVector = new class_243(0.0, 1.0, 0.0);
        class_243 rightVector = this.dir.method_1036(upVector).method_1029();
        if (class_3532.method_20390((double)rightVector.method_1033(), (double)0.0)) {
            rightVector = new class_243(1.0, 0.0, 0.0).method_1036(this.dir).method_1029();
        }
        class_243 rotated = Vec3Util.rotateVector(this.dir(), rightVector, Math.toRadians(degrees));
        return new PointOfView(this.pos, rotated);
    }

    public PointOfView rotateY(double degrees) {
        return new PointOfView(this.pos, this.dir.method_1024((float)Math.toRadians(degrees)));
    }

    public PointOfView move(double x, double y, double z) {
        return new PointOfView(this.pos.method_1031(x, y, z), this.dir);
    }

    public PointOfView reverseDirection() {
        return new PointOfView(this.pos, this.dir.method_22882());
    }

    public PointOfView limitMaxDistance(CameraHolder holder, double distance) {
        return this.limitMaxDistance(holder.asHolderEntity(), distance);
    }

    public PointOfView limitMaxDistance(class_1297 entity, double distance) {
        float maxDistance = this.getMaxCameraDistance(entity, this.pos, this.dir, (float)distance);
        return new PointOfView(this.pos.method_1019(this.dir.method_1029().method_1021((double)(-maxDistance))), this.dir);
    }

    private float getMaxCameraDistance(class_1297 entity, class_243 position, class_243 direction, float maxDistance) {
        for (int i = 0; i < 8; ++i) {
            float distanceSqr;
            float xOff = (i & 1) * 2 - 1;
            float yOff = (i >> 1 & 1) * 2 - 1;
            float zOff = (i >> 2 & 1) * 2 - 1;
            class_243 pos = position.method_1031((double)(xOff * 0.1f), (double)(yOff * 0.1f), (double)(zOff * 0.1f));
            class_243 endPos = pos.method_1019(direction.method_1021((double)(-maxDistance)));
            class_3965 hitResult = entity.method_37908().method_17742(new class_3959(pos, endPos, class_3959.class_3960.field_23142, class_3959.class_242.field_1348, class_3726.method_16195((class_1297)entity)));
            if (hitResult.method_17783() == class_239.class_240.field_1333 || !((distanceSqr = (float)hitResult.method_17784().method_1025(position)) < class_3532.method_27285((float)maxDistance))) continue;
            maxDistance = class_3532.method_15355((float)distanceSqr);
        }
        return maxDistance;
    }
}

